// BullsEye.h : Deklaracja CBullsEye

#ifndef __BULLSEYE_H_
#define __BULLSEYE_H_

#include "resource.h"       // gwne symbole
#include <atlctl.h>
#include "BullsEyeEventsCP.h"
#include "IDropSourceImpl.h"

/////////////////////////////////////////////////////////////////////////////
// CBullsEyeLicense

// Obiekty z licencj implementuj IClassFactory2 w celu weryfikacji da utworzenia egzemplarza.

// Aby utworzy taki obiekt przy uyciu IClassFactory2::CreateInstance,
//   danie musi by zgoszone w czasie projektowania licencjonowanego systemu.

// W celu utworzenia obiektu z licencj przy uyciu IClassFactory2::CreateInstanceLic:
//   klient musi przedstawi poprawny klucz licencji moduu wykonawczego lub
//   danie tworzenia musi wystpi w systemie licencjonowanym.

// Klient moe ustali, czy aktualny system posiada licencj na uycie obiektu
// oraz czy klucz moduu wykonawczego jest dostpny poprzez wywoanie IClassFactory2:GetLicInfo.

// W przypadku licencjonowanego systemu klient moe uzyska klucz licencji
// poprzez wywoanie IClassFactory2::RequestLicKey.


// Implementacja ATL IClassFactory2 wykorzystuje nastpujce metody:

// IsLicenseValid zwraca niezerow warto, jeli aktualny system posiada licencj.
// VerifyLicenseKey zwraca niezerow warto, jeli modu wywoujcy przekae poprawny klucz licencji.
// GetLicenseKey zwraca klucz licencji.

class CBullsEyeLicense {
private:
    static const GUID RunTimeLicenseKey ;

protected:
    // Poniszy kod powinien sprawdza obecno sprztowego klucza, tajnego klucza rejestru lub innych
    // podobnych zabezpiecze wiadczcych o posiadaniu przez dany system licencji na uycie obiektu.
    static BOOL IsLicenseValid() { return TRUE; }

    // Weryfikacja przedstawionego klucza licencji.
    // Powinien to by GUID przeksztacony do cigu.
    static BOOL VerifyLicenseKey(BSTR bstr) {
        OLECHAR buf [40];

        int i = StringFromGUID2 (RunTimeLicenseKey, buf, sizeof (buf));
        ATLASSERT (i != 0);

        return !lstrcmpW(bstr, buf);
    }

    // Zwraca klucz licencji jako BSTR.
    // Jako klucz wykorzystywany jest GUID przeksztacony do cigu.
    static BOOL GetLicenseKey(DWORD dwReserved, BSTR* pBstr) {
        OLECHAR buf [40];

        int i = StringFromGUID2 (RunTimeLicenseKey, buf, sizeof (buf));
        ATLASSERT (i != 0);

        *pBstr = SysAllocString(buf); 
        return TRUE;
    }

};


/////////////////////////////////////////////////////////////////////////////
// CBullsEye

const int PROPCAT_Scoring = 1;
    
class ATL_NO_VTABLE CBullsEye : 
    // COM object
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CBullsEye, &CLSID_BullsEye>,
    // Implementacja elementu sterujcego
	public CComControl<CBullsEye>,
	public CStockPropImpl<CBullsEye, IBullsEye, &IID_IBullsEye, &LIBID_BullsEyeLib>,
	public IOleControlImpl<CBullsEye>,
	public IOleObjectImpl<CBullsEye>,
	public IOleInPlaceActiveObjectImpl<CBullsEye>,
	public IViewObjectExImpl<CBullsEye>,
	public IOleInPlaceObjectWindowlessImpl<CBullsEye>,
	public IQuickActivateImpl<CBullsEye>,
	public IDataObjectImpl<CBullsEye>,
    // Obsuga Object Safety support
    public IObjectSafetyImpl<CBullsEye, INTERFACESAFE_FOR_UNTRUSTED_CALLER |
                                        INTERFACESAFE_FOR_UNTRUSTED_DATA>,
    // Trwao
	public IPersistStreamInitImpl<CBullsEye>,
	public IPersistStorageImpl<CBullsEye>,
    public IPersistPropertyBagImpl<CBullsEye>,
    // Implementacja stronicy waciwoci
	public ISpecifyPropertyPagesImpl<CBullsEye>,
	public IPerPropertyBrowsingImpl<CBullsEye>,
    // Kategorie waciwoci dla Visual Basic Property View
    public ICategorizeProperties,
    // Obsuga kontenera punktu poczenia
	public IConnectionPointContainerImpl<CBullsEye>,
            // Konieczno aktualizacji drugiego parametru na domylne rdo (zdarzenie) dispinterface IID
	public IProvideClassInfo2Impl<&CLSID_BullsEye, &DIID__IBullsEyeEvents, &LIBID_BullsEyeLib>,
    // Powiadomienia o zmianie zdarze i waciwoci
	public CProxy_IBullsEyeEvents<CBullsEye>,
    public IPropertyNotifySinkCP<CBullsEye>,
    // Implementacja DropSource
    public IDropSourceImpl<CBullsEye>
{
public:
	CBullsEye();
	~CBullsEye();

    static void WINAPI ObjectMain(bool bStarting)
    {
        m_cfEmbeddedObject   = RegisterClipboardFormat(CF_EMBEDDEDOBJECT); 
        m_cfObjectDescriptor = RegisterClipboardFormat(CF_OBJECTDESCRIPTOR); 

        IDropSourceImpl<CBullsEye>::ObjectMain(bStarting);
    }

DECLARE_CLASSFACTORY2(CBullsEyeLicense)
DECLARE_REGISTRY_RESOURCEID(IDR_BULLSEYE)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CBullsEye)
    // Implementacja elementu sterujcego
	COM_INTERFACE_ENTRY(IBullsEye)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IDataObject)
    // Obsuga Object Safety
    COM_INTERFACE_ENTRY(IObjectSafety)
    // Trwao
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IPersistPropertyBag)
    // Implementacja stronicy waciwoci
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IPerPropertyBrowsing)
    // Kategorie waciwoci dla Visual Basic Property View
	COM_INTERFACE_ENTRY(ICategorizeProperties)
    // Obsuga kontenera punktu poczenia
	COM_INTERFACE_ENTRY(IConnectionPointContainer)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
    // Implementacja DropSource
    COM_INTERFACE_ENTRY(IDropSource)
END_COM_MAP()

BEGIN_CATEGORY_MAP(CBullsEye)
IMPLEMENTED_CATEGORY(CATID_ATLINTERNALS_SAMPLES)
END_CATEGORY_MAP()

BEGIN_CONNECTION_POINT_MAP(CBullsEye)
	CONNECTION_POINT_ENTRY(DIID__IBullsEyeEvents)
	CONNECTION_POINT_ENTRY(IID_IPropertyNotifySink)
END_CONNECTION_POINT_MAP()

BEGIN_PROP_MAP(CBullsEye)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	PROP_ENTRY("BackStyle",      DISPID_BACKSTYLE,      CLSID_BullsEyePropPage)
	PROP_ENTRY("Beep",           DISPID_BEEP,           CLSID_BullsEyePropPage)
	PROP_ENTRY("Enabled",        DISPID_ENABLED,        CLSID_BullsEyePropPage)
	PROP_ENTRY("RingCount",      DISPID_RINGCOUNT,      CLSID_BullsEyePropPage)

    PROP_ENTRY("AlternateColor", DISPID_ALTERNATECOLOR, CLSID_StockColorPage)
	PROP_ENTRY("BackColor",      DISPID_BACKCOLOR,      CLSID_StockColorPage)
	PROP_ENTRY("CenterColor",    DISPID_CENTERCOLOR,    CLSID_StockColorPage)
	PROP_ENTRY("ForeColor",      DISPID_FORECOLOR,      CLSID_StockColorPage)
	// Przykadowe wpisy
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_MSG_MAP(CBullsEye)
	CHAIN_MSG_MAP(CComControl<CBullsEye>)
	DEFAULT_REFLECTION_HANDLER()
	MESSAGE_HANDLER(WM_LBUTTONDOWN, OnLButtonDown)
END_MSG_MAP()
// Prototypy procedur obsugi:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);

    HRESULT FinalConstruct ();

// IPerPropertyBrowsing
	STDMETHODIMP GetDisplayString(/*[in]*/ DISPID dispid, /*[out]*/ BSTR *pBstr);
    STDMETHODIMP GetPredefinedStrings(/*[in]*/ DISPID dispID, /*[out]*/ CALPOLESTR *pcaStringsOut, /*[out]*/ CADWORD *pcaCookiesOut);
    STDMETHODIMP GetPredefinedValue(/*[in]*/ DISPID dispID, /*[in]*/DWORD dwCookie, /*[out]*/VARIANT* pVarOut);
    STDMETHODIMP MapPropertyToPage(/*[in]*/ DISPID dispID, /*[out*/ CLSID *pClsid);

// ICategorizeProperties
    STDMETHODIMP MapPropertyToCategory(/*[in]*/ DISPID dispid, /*[out]*/ PROPCAT* ppropcat);
    STDMETHODIMP GetCategoryName(/*[in]*/ PROPCAT propcat, /*[in]*/ LCID lcid, /*[out]*/ BSTR* pbstrName);

// IViewObjectEx
	STDMETHODIMP GetViewStatus (DWORD* pdwStatus);
    STDMETHODIMP QueryHitPoint (DWORD dwAspect, LPCRECT pRectBounds, POINT ptlLoc, LONG lCloseHint, DWORD* pHitResult);
    STDMETHODIMP QueryHitRect (DWORD dwAspect, LPCRECT pRectBounds, LPCRECT prcLoc, LONG lCloseHint, DWORD* pHitResult);

// IDataObject
    STDMETHODIMP QueryGetData(FORMATETC* pformatetc);
    STDMETHODIMP EnumFormatEtc(DWORD dwDirection, IEnumFORMATETC** ppenumFormatEtc);

// IOleObject
    STDMETHODIMP GetMiscStatus (DWORD dwAspect, DWORD *pdwStatus);

// IOleControl
    STDMETHODIMP OnAmbientPropertyChange (DISPID dispid);
    STDMETHODIMP GetControlInfo(CONTROLINFO *pCI);

//IOleInPlaceActiveObject
    STDMETHODIMP TranslateAccelerator(MSG *pMsg);

// CComControlBase
    HRESULT IQuickActivate_QuickActivate(QACONTAINER *pQACont, QACONTROL *pQACtrl);
    HRESULT IOleObject_SetClientSite(IOleClientSite *pClientSite);
    HRESULT IPersistStreamInit_Load(LPSTREAM pStm, ATL_PROPMAP_ENTRY* pMap);
    HRESULT IPersistStreamInit_Save(LPSTREAM pStm, BOOL fClearDirty, ATL_PROPMAP_ENTRY* pMap);
    HRESULT IPersistPropertyBag_Load(LPPROPERTYBAG pPropBag, LPERRORLOG pErrorLog, ATL_PROPMAP_ENTRY* pMap);
    HRESULT IPersistPropertyBag_Save(LPPROPERTYBAG pPropBag, BOOL fClearDirty, BOOL fSaveAllProperties, ATL_PROPMAP_ENTRY* pMap);
    STDMETHODIMP InitNew();

// IBullsEye
public:
    STDMETHODIMP get_AlternateColor(/*[out, retval]*/ OLE_COLOR *pVal);
    STDMETHODIMP put_AlternateColor(/*[in]*/ OLE_COLOR newVal);
    STDMETHODIMP get_Application(/*[out, retval]*/ LPDISPATCH *pVal);
    STDMETHODIMP get_Beep(/*[out, retval]*/ VARIANT_BOOL *pVal);
    STDMETHODIMP put_Beep(/*[in]*/ VARIANT_BOOL newVal);
    STDMETHODIMP put_BackStyle(/*[in]*/ LONG nBackStyle);
    STDMETHODIMP put_BackColor(/*[in]*/OLE_COLOR newVal);
    STDMETHODIMP get_CenterColor(/*[out, retval]*/ OLE_COLOR *pVal);
    STDMETHODIMP put_CenterColor(/*[in]*/ OLE_COLOR newVal);
    STDMETHODIMP get_Parent(/*[out, retval]*/ LPDISPATCH *pVal);
    STDMETHODIMP get_RingValue(/*[in]*/ short sRingNumber, /*[out, retval]*/ long *pVal);
    STDMETHODIMP put_RingValue(/*[in]*/ short sRingNumber, /*[in]*/ long newVal);
    STDMETHODIMP get_RingCount(/*[out, retval]*/ short *pVal);
    STDMETHODIMP put_RingCount(/*[in]*/ short newVal);

    STDMETHODIMP Refresh();
    STDMETHODIMP DoClick();
    STDMETHODIMP AboutBox();

    HRESULT OnDraw(ATL_DRAWINFO& di);
    HRESULT OnDrawAdvanced(ATL_DRAWINFO& di);

    void DrawBullsEye (ATL_DRAWINFO& di);

    LRESULT OnLButtonDown(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
    int HitTest (const CPoint& pt);

// Implementacja
public:
    OLE_COLOR                   m_clrBackColor;     // Waciwo BackColor
	OLE_COLOR                   m_clrForeColor;     // Waciwo ForeColor
    long                        m_nBorderStyle;     // Waciwo BorderStyle
    long                        m_nBorderWidth;     // Waciwo BorderWidth
    long                        m_nBackStyle;       // Waciwo BackStyle
	BOOL                        m_bEnabled;         // Waciwo Enabled

    OLE_COLOR                   m_clrCenterColor ;      // Kolor parzystych piercieni
	OLE_COLOR                   m_clrAlternateColor ;   // Kolor nieparzystych piercieni
	VARIANT_BOOL                m_beep ;                // Dwik po trafieniu piercienia?
	CSimpleArray<long>          m_ringValues ;          // Wartoci punktowe dla piercieni

    short                       m_nAppearance;      // Waciwo Ambient Appearance

    bool                        m_bAmbientsFetched; // Czy uzyskano ju wartoci Ambients?

    HPEN                        m_borderPen ;       // Piro dla krawdzi piercieni
	HBRUSH                      m_backBrush ;       // Pdzel dla ta wok tarczy
	HBRUSH                      m_alternateBrush ;  // Pdzel dla alternatywnego koloru piercieni
	HBRUSH                      m_centerBrush ;     // Pdzel dla gwnego koloru piercieni

	void    HitRing (short sRingNumber);
    HRESULT GetPropertyFromDocument (/* [in] */ LPOLESTR pszProperty, /* [out] */ IDispatch** pDisp) ;
	HRESULT GetApplicationFromServiceProvider (/* [out] */ IDispatch** pDisp) ;
    HRESULT SendOnViewExChange(DWORD dwViewStatus);

    static CLIPFORMAT m_cfEmbeddedObject;
    static CLIPFORMAT m_cfObjectDescriptor;
};

#endif //__BULLSEYE_H_
